﻿
CREATE PROCEDURE [App].[NVCC_usp_GetXdwFacility]
	-- @LCustomerID is from CDWWork.LCustomer.LCustomer
	@LCustomerID int
AS
--==================================================================================
--Requestor             : Non Va Coordinated Care Project
--Author                : Brian Diggs
--Object/SP Name        : NVCC_usp_GetXdwFacility
--Server                : 
--Data Base             : CC_REFDOC
--Schema                : app
--Report                : N/A
--Folder                : N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 2017-02-14
--
--
--Last Changed          : 
--Last Changed By		: 
--Reason For Change		: 
--
--Purpose               : To get the sites for which a user has PHI/PII access
--==================================================================================
--Uses: App.udf_StationName
--Uses: CDWWork.LCustomer.AllPermissions
--Uses: CDWWork.Dim.Sta3n

BEGIN
	SELECT
		s.Sta3n AS FacilityID
		,App.udf_StationName(s.Sta3n) AS FacilityName
		,s.VISNFY17 AS VISN
		,s.DistrictNumberFY17 AS District
	FROM CDWWork.LCustomer.AllPermissions AS ap
		JOIN CDWWork.Dim.Sta3n AS s
			ON ap.Sta3n = s.Sta3n
	WHERE 
		ap.LCustomerID = @LCustomerID 
		AND ap.PHIPII = 1 
		AND ap.Sta3n > 0
		AND s.Active = 'Y'
END

